/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.wsrr;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.property.wsrr.VWConfigWSRRRegistryListTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import filenet.vw.toolkit.utils.ws.wsrr.IVWWSRRPanelOperation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class VWConfigWSRRRegistryListPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWWSRRPanelOperation {
    private VWWSRRRegistryList m_WSRRRegistryList = null;
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_WSRRRegistriesTable = null;
    private VWConfigWSRRRegistryListTableModel m_tableModel = null;

    public VWConfigWSRRRegistryListPanel(Frame parentFrame, VWWSRRRegistryList WSRRRegistryList) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_WSRRRegistryList = WSRRRegistryList;
            this.m_session = this.m_WSRRRegistryList.getSession();
            this.createControls();
            this.m_WSRRRegistriesTable.clearSelection();
            if (this.m_WSRRRegistriesTable.getRowCount() > 0) {
                this.m_WSRRRegistriesTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x100000));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_tableModel.hasChanged();
    }

    public void stopEditing() {
        if (this.m_WSRRRegistriesTable != null) {
            this.m_WSRRRegistriesTable.stopEditing();
        }
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopEditing();
            if (this.hasChanged() && (bSuccess = this.m_tableModel.verifyWSRRRegistries())) {
                VWWSRRRegistry[] WSRRRegistries = this.m_tableModel.getWSRRRegistries();
                this.m_WSRRRegistryList.setWSRRRegistries(WSRRRegistries);
                this.m_WSRRRegistryList.updateAttribute();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public boolean validateData() {
        boolean bSuccess = true;
        if (this.m_tableModel.hasChanged()) {
            bSuccess = this.m_tableModel.verifyWSRRRegistries();
        }
        return bSuccess;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_WSRRRegistriesTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_WSRRRegistriesTable.getSelectedRow()) {
                    this.m_WSRRRegistriesTable.clearSelection();
                }
                this.m_WSRRRegistriesTable.setRowSelectionInterval(nRow, nRow);
                this.m_WSRRRegistriesTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int selectedRow = this.m_WSRRRegistriesTable.getSelectedRow();
            if (selectedRow < 0) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x100000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x100000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_WSRRRegistriesTable.setRowSelectionInterval(nRow, nRow);
                    this.m_WSRRRegistriesTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 0x100000: {
                    this.onValidateRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createWSRRRegistriesPanel();
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_WSRRRegistryList != null) {
            this.m_WSRRRegistryList.releaseResources();
            this.m_WSRRRegistryList = null;
        }
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_WSRRRegistriesTable != null) {
            this.m_WSRRRegistriesTable.removeAll();
            this.m_WSRRRegistriesTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    private void createWSRRRegistriesPanel() {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.s_wsrrRegistryList, 0x10100010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigWSRRRegistryListTableModel(this.m_parentFrame, this.m_session, this.m_WSRRRegistryList.getWSRRRegistries());
            this.m_tableModel.addTableModelListener(this);
            this.m_WSRRRegistriesTable = new VWTable(this.m_tableModel);
            this.m_WSRRRegistriesTable.setRowSelectionAllowed(true);
            this.m_WSRRRegistriesTable.getSelectionModel().addListSelectionListener(this);
            this.m_WSRRRegistriesTable.getSelectionModel().setSelectionMode(0);
            this.m_WSRRRegistriesTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_WSRRRegistriesTable, this, VWResource.WSRRRegistryListTable, VWResource.WSRRRegistryListTable);
            this.m_WSRRRegistriesTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_WSRRRegistriesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn aColumn = this.m_WSRRRegistriesTable.getColumn(this.m_tableModel.getColumnName(2));
            aColumn.setMaxWidth(20);
            aColumn.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("publish_16.gif"), VWResource.Publish));
            aColumn = this.m_WSRRRegistriesTable.getColumn(this.m_tableModel.getColumnName(4));
            PasswordRenderer passwordRenderer = new PasswordRenderer();
            aColumn.setCellRenderer(passwordRenderer);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            JPasswordField password = new JPasswordField();
            password.setBorder(new LineBorder(Color.BLACK));
            password.setComponentOrientation(compOrientation);
            DefaultCellEditor editor = new DefaultCellEditor(password);
            aColumn.setCellEditor(editor);
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_WSRRRegistriesTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_WSRRRegistriesTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean validateURLs(VWWSRRRegistry vwRegistry) {
        String registryURL = null;
        try {
            VWWSRRRegistryItem vwWSRRRegItem = new VWWSRRRegistryItem(this.m_session, vwRegistry);
            registryURL = vwWSRRRegItem.getWSRRURL();
            URL oURL = new URL(registryURL);
            if (oURL == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidUDDIInquiryURL, VWResource.ErrorMessage, 1);
                return false;
            }
            URLConnection aURLCN = oURL.openConnection();
            if (aURLCN == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_failedToConnectInquiryURL, VWResource.ErrorMessage, 1);
                return false;
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidURL.toString(ex.getLocalizedMessage()), VWResource.ErrorMessage, 1);
            return false;
        }
        return true;
    }

    private void onValidateRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_WSRRRegistriesTable.getSelectedRows();
            for (int nIndex = 0; nIndex < rows.length; ++nIndex) {
                this.m_tableModel.validateRow(rows[nIndex], true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    static class PasswordRenderer
    extends DefaultTableCellRenderer {
        PasswordRenderer() {
        }

        protected void setValue(Object value) {
            String sValue;
            String returnedString = null;
            if (value instanceof String && (sValue = (String)value) != null) {
                char[] sEncoded = new char[sValue.length()];
                for (int i = 0; i < sValue.length(); ++i) {
                    sEncoded[i] = 42;
                }
                returnedString = new String(sEncoded);
            }
            if (returnedString == null) {
                this.setText("");
            } else {
                this.setText(returnedString);
            }
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
    }
}

